#pragma once
#include "ConfigDlg.h"
#include "ConfigGPRS.h"
#include "resource.h"
#include "afxwin.h"
#include "afxcmn.h"
#include "ProfileDll.h"
#include "ListCtrlEx.h"

#define kGPRSCidIndexColumn				0
#define kGPRSAPNIndexColumn				1
#define kGPRSStateIndexColumn			2
#define kGPRSTypeIndexColumn			3
#define kGPRSAddIndexColumn				4
#define kGPRSColCount					kGPRSAddIndexColumn+1

/////////////////////////////////////////////////////////////////////////////
// CConfigGPRSDlg dialog
class CConfigGPRSDlg : public CConfigDlg
{
	DECLARE_DYNAMIC(CConfigGPRSDlg)
private:
	virtual int		GetIconId()		{ return IDI_ICON_GPRS; };
public:
	enum {	IDD = IDD_DLGCFG_GPRS_MAIN	};
	CConfigGPRSDlg(CConfigGPRS* iCfgGPRS) : CConfigDlg(CConfigGPRSDlg::IDD, theApp.m_hInstance, iCfgGPRS){};
	virtual ~CConfigGPRSDlg() {};	
protected:
	virtual void DoDataExchange(CDataExchange* pDX)	{ CDialog::DoDataExchange(pDX); };
	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL	OnInitDialog()	{ CDialog::OnInitDialog(); return TRUE; };
	virtual char*	GetName()		{ return "GPRS";};
	virtual void	UpdateDisplay()	{};
	virtual BOOL	Apply()			{ return TRUE; };
};

/////////////////////////////////////////////////////////////////////////////
// CConfigGPRSDlgSettings dialog
class CConfigGPRSDlgSettings : public CConfigDlg
{
	DECLARE_DYNAMIC(CConfigGPRSDlgSettings)
protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	DECLARE_MESSAGE_MAP()

public:
	CConfigGPRSDlgSettings(CConfigGPRS* iCfgGPRS): CConfigDlg(CConfigGPRSDlgSettings::IDD, theApp.m_hInstance, iCfgGPRS){};
	virtual ~CConfigGPRSDlgSettings() {};

	enum { IDD = IDD_DLGCFG_GPRS_SETTINGS };

	virtual void	UpdateDisplay();
	virtual char*	GetName()		{ return "Settings";};
	virtual BOOL	OnInitDialog();
	virtual BOOL	Apply();
	CComboBox		mRegStateCombo, mRegNotifStateCombo, mResCodeBfrCombo, mResCodeModeCombo;
	CButton			mAttachCheck;
	CEdit			mCellIDEdit, mAreaCodeEdit;

	afx_msg void OnBnClickedGprsRegSendNotifButton();
};
/////////////////////////////////////////////////////////////////////////////
// CConfigGPRSDlgPDPParams dialog
class CConfigGPRSDlgPDPParams : public CConfigDlg
{
	DECLARE_DYNAMIC(CConfigGPRSDlgPDPParams)
protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	DECLARE_MESSAGE_MAP()

public:
	CConfigGPRSDlgPDPParams(CConfigGPRS* iCfgGPRS, int iPDPId): CConfigDlg(CConfigGPRSDlgPDPParams::IDD, theApp.m_hInstance, iCfgGPRS) {mPDPId = iPDPId; mCtxtParamP = NULL;};

	virtual ~CConfigGPRSDlgPDPParams() { delete mCtxtParamP; };
	enum { IDD = IDD_DLGCFG_GPRS_PDP_PARAMS };
	virtual void	UpdateDisplay();
	virtual char*	GetName()		{ return mName.GetBuffer(0); }
	virtual BOOL	OnInitDialog();
	virtual BOOL	Apply();
	void			FillContextParameters();
	void			FillComboType();
	afx_msg void	OnComboTypeChange();
	afx_msg void	OnPD1Change();
	afx_msg void	OnPD2Change();
	afx_msg void	OnPD3Change();

	

public:
	CString			mName;
	UInt8			mPDPId;
	CGPRSContext*	mCtxtParamP;

	CComboBox		mPDPTypeCombo, mComboPD3;
	CComboBox		mReqPrecedenceCombo, mReqDelayCombo, mReqReliabilityCombo, mReqPeakCombo, mReqMeanCombo;
	CComboBox		mMinPrecedenceCombo, mMinDelayCombo, mMinReliabilityCombo, mMinPeakCombo, mMinMeanCombo;
	CEdit			mCIDEdit, mAPNEdit, mAddrEdit, mPD1Edit, mPD2Edit;
	CButton			mHeaderCompCheck, mDataCompCheck;
};
/////////////////////////////////////////////////////////////////////////////
// CConfigGPRSDlgPDPManage dialog
class CConfigGPRSDlgPDPManage: public CConfigDlg
{
	DECLARE_DYNAMIC(CConfigGPRSDlgPDPManage)
private:
	void			FillContextList();
protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	DECLARE_MESSAGE_MAP()
public:
	CConfigGPRSDlgPDPManage(CConfigGPRS* iCfgGPRS): CConfigDlg(CConfigGPRSDlgPDPManage::IDD, theApp.m_hInstance, iCfgGPRS){mExtended = true;};
	virtual ~CConfigGPRSDlgPDPManage();

	enum { IDD = IDD_DLGCFG_GPRS_URC };

	virtual void		UpdateDisplay();
	virtual char*		GetName()		{ return "PDP Management";};
	virtual BOOL		OnInitDialog();
	virtual BOOL		Apply();
	virtual int			GetExtDlgCount();
	virtual CConfigDlg*	GetExtDlgUI(int iId);

	UInt8				mCurrPDP;
	CComboBox			mClassCombo;
	CListCtrlEx			mCtxtListCtrl;
	CList<CConfigGPRSDlgPDPParams*, CConfigGPRSDlgPDPParams*> mPDPDlgList;
	CList<CGPRSContext, CGPRSContext&> mLocalCtxtList;
	CList<CGPRSEvtNotif, CGPRSEvtNotif&> UnsoResCodToadd;
	
public:
	afx_msg void		OnBnClickedGprsCtxtAddPdpButton();
	afx_msg void		OnBnClickedGprsCtxtRemovePdpButton();
	afx_msg void		OnBnClickedGprsCtxtActivatePdpButton();
	afx_msg void		OnBnClickedGprsCtxtDeactivatePdpButton();
	afx_msg void 		OnBnClickedGprsCtxtResCodeFlushBuf();
	afx_msg void 		OnBnClickedGprsCtxtResCodeReject();
	afx_msg void 		OnBnClickedGprsCtxtResCodeNwReact();
	afx_msg void 		OnBnClickedGprsCtxtResCodeNwDeact();
	afx_msg void 		OnBnClickedGprsCtxtResCodeNwDetach();
	afx_msg void 		OnBnClickedGprsCtxtResCodeMwClass();
	afx_msg void 		OnBnClickedGprsCtxtResCodeMeDetach();
	afx_msg void 		OnBnClickedGprsCtxtResCodeMeClass();
	afx_msg void 		OnBnClickedGprsCtxtResCodeMeDeact();
	afx_msg void		OnLvnItemchangedGprsCtxtList(NMHDR *pNMHDR, LRESULT *pResult);	
};

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
